<?php
declare(strict_types=1);

require __DIR__ . '/../config/db.php';
require __DIR__ . '/partials/header.php';

$ok = '';
$err = '';

$name = trim($_POST['name'] ?? '');
$email = trim($_POST['email'] ?? '');
$phone = trim($_POST['phone'] ?? '');
$service = trim($_POST['service'] ?? '');
$preferred_date = trim($_POST['preferred_date'] ?? '');
$preferred_time = trim($_POST['preferred_time'] ?? '');
$details = trim($_POST['details'] ?? '');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($name === '' || $email === '') {
        $err = "Nom et email sont obligatoires.";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $err = "Email invalide.";
    } else {
        try {
            $pdo = db();
            $stmt = $pdo->prepare("
                INSERT INTO appointment_requests
                  (name, email, phone, service, preferred_date, preferred_time, details)
                VALUES
                  (:n, :e, :p, :s, :d, :t, :x)
            ");
            $stmt->execute([
                ':n' => $name,
                ':e' => $email,
                ':p' => ($phone !== '' ? $phone : null),
                ':s' => ($service !== '' ? $service : null),
                ':d' => ($preferred_date !== '' ? $preferred_date : null),
                ':t' => ($preferred_time !== '' ? $preferred_time : null),
                ':x' => ($details !== '' ? $details : null),
            ]);
            $ok = "Demande envoyée. On te recontacte pour confirmer.";
            $name = $email = $phone = $service = $preferred_date = $preferred_time = $details = '';
        } catch (Throwable $e) {
            $err = "Erreur serveur lors de l’envoi.";
        }
    }
}
?>
<div class="card">
  <h1>Demande de rendez-vous</h1>

  <?php if ($ok): ?><div class="notice ok"><?= h($ok) ?></div><?php endif; ?>
  <?php if ($err): ?><div class="notice err"><?= h($err) ?></div><?php endif; ?>

  <form method="post" action="">
    <div class="form-row">
      <div>
        <label>Nom *</label>
        <input name="name" value="<?= h($name) ?>" required>
      </div>
      <div>
        <label>Email *</label>
        <input name="email" value="<?= h($email) ?>" required>
      </div>
    </div>

    <div class="form-row">
      <div>
        <label>Téléphone</label>
        <input name="phone" value="<?= h($phone) ?>">
      </div>
      <div>
        <label>Service</label>
        <select name="service">
          <option value="">— Choisir —</option>
          <?php
            $services = ['Retouches', 'Ourlet', 'Réparation', 'Fermeture éclair', 'Sur mesure', 'Autre'];
            foreach ($services as $s) {
              $sel = ($service === $s) ? 'selected' : '';
              echo '<option ' . $sel . ' value="' . h($s) . '">' . h($s) . '</option>';
            }
          ?>
        </select>
      </div>
    </div>

    <div class="form-row">
      <div>
        <label>Date souhaitée</label>
        <input type="date" name="preferred_date" value="<?= h($preferred_date) ?>">
      </div>
      <div>
        <label>Heure souhaitée</label>
        <input placeholder="ex: 10:30 ou Après-midi" name="preferred_time" value="<?= h($preferred_time) ?>">
      </div>
    </div>

    <label>Détails</label>
    <textarea name="details"><?= h($details) ?></textarea>

    <p style="margin-top:12px;">
      <button class="btn" type="submit">Envoyer la demande</button>
    </p>
  </form>
</div>
<?php require __DIR__ . '/partials/footer.php'; ?>
