<?php
// public/partials/header.php
declare(strict_types=1);

$cfg = require __DIR__ . '/../../config/config.php';
$siteName = $cfg['site_name'];
$baseUrl  = rtrim($cfg['base_url'], '/');

function h(string $v): string {
    return htmlspecialchars($v, ENT_QUOTES, 'UTF-8');
}

$current = $_SERVER['SCRIPT_NAME'] ?? '';
?>
<!doctype html>
<html lang="fr">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= h($siteName) ?></title>
  <link rel="stylesheet" href="<?= h($baseUrl) ?>/assets/css/style.css?v=<?= filemtime(__DIR__ . '/../assets/css/style.css') ?>">
</head>
<body>
<header class="site-header">
  <div class="container header-row">
    <div class="brand">
      <a href="<?= h($baseUrl) ?>/index.php"><?= h($siteName) ?></a>
    </div>

    <nav class="nav">
      <a class="<?= str_contains($current, '/index.php') ? 'active' : '' ?>" href="<?= h($baseUrl) ?>/index.php">Accueil</a>
      <a class="<?= str_contains($current, '/services.php') ? 'active' : '' ?>" href="<?= h($baseUrl) ?>/services.php">Services</a>
      <a class="<?= str_contains($current, '/galerie.php') ? 'active' : '' ?>" href="<?= h($baseUrl) ?>/galerie.php">Galerie</a>
      <a class="<?= str_contains($current, '/tarifs.php') ? 'active' : '' ?>" href="<?= h($baseUrl) ?>/tarifs.php">Tarifs</a>
      <a class="<?= str_contains($current, '/rendez_vous.php') ? 'active' : '' ?>" href="<?= h($baseUrl) ?>/rendez_vous.php">Rendez-vous</a>
      <a class="<?= str_contains($current, '/contact.php') ? 'active' : '' ?>" href="<?= h($baseUrl) ?>/contact.php">Contact</a>
    </nav>
  </div>
</header>

<main class="container">
