<?php
// public/partials/footer.php
declare(strict_types=1);

$cfg = require __DIR__ . '/../../config/config.php';
$siteName = $cfg['site_name'];
$baseUrl  = rtrim($cfg['base_url'], '/');

// Racine du projet (ex: /couture_site)
$projectRoot = rtrim(dirname($baseUrl), '/');
$adminLoginUrl = $projectRoot . '/auth/login.php';
?>
</main>

<footer class="site-footer">
  <div class="container footer-row">
    <div>© <?= date('Y') ?> <?= htmlspecialchars($siteName, ENT_QUOTES, 'UTF-8') ?></div>
    <div><a href="<?= htmlspecialchars($adminLoginUrl, ENT_QUOTES, 'UTF-8') ?>">Admin</a></div>
  </div>
</footer>
</body>
</html>
