<?php
// public/index.php
declare(strict_types=1);

require __DIR__ . '/partials/header.php';
?>
<section class="hero">
  <h1><?= h($siteName) ?></h1>
  <p>Retouches, confection sur mesure, réparations et créations. Service rapide et finition soignée.</p>

  <p style="margin-top:14px; display:flex; gap:10px; flex-wrap:wrap;">
    <a class="btn" href="...">Demander un rendez-vous</a>
    <a class="btn outline" href="<?= h($baseUrl) ?>/galerie.php">Voir la galerie</a>
  </p>
</section>

<div class="grid" style="margin-top:14px;">
  <div class="card col-6">
    <h2>Services</h2>
    <p>Ourlets, ajustements, fermeture éclair, retouches sur vêtements et textiles.</p>
    <a class="btn outline" href="<?= h($baseUrl) ?>/services.php">Découvrir</a>
  </div>

  <div class="card col-6">
    <h2>Sur mesure</h2>
    <p>Projets personnalisés, tenues, robes, modifications complexes, conseils tissus.</p>
    <a class="btn outline" href="<?= h($baseUrl) ?>/rendez_vous.php">Prendre rendez-vous</a>
  </div>

  <div class="card col-12">
    <h2>Contact</h2>
    <p>Tu peux envoyer un message ou une demande de rendez-vous. Réponse sous 24–48h.</p>
    <a class="btn outline" href="<?= h($baseUrl) ?>/contact.php">Nous contacter</a>
  </div>
</div>

<?php require __DIR__ . '/partials/footer.php'; ?>
