<?php
// public/galerie_detail.php
declare(strict_types=1);

require __DIR__ . '/../config/db.php';
require __DIR__ . '/partials/header.php';

$pdo = db();

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    header('Location: ' . rtrim($baseUrl, '/') . '/galerie.php');
    exit;
}

$stmt = $pdo->prepare("
  SELECT id, title, description, category, image_path, created_at
  FROM gallery_items
  WHERE id = :id AND is_published = 1
  LIMIT 1
");
$stmt->execute([':id' => $id]);
$item = $stmt->fetch();

if (!$item) {
    ?>
    <div class="card">
      <h1>Introuvable</h1>
      <p>Cette réalisation n’existe pas ou n’est pas publiée.</p>
      <p><a class="btn outline" href="<?= h(rtrim($baseUrl, '/')) ?>/galerie.php">Retour galerie</a></p>
    </div>
    <?php
    require __DIR__ . '/partials/footer.php';
    exit;
}

$base = rtrim($baseUrl, '/');
?>
<div class="card">
  <p><a class="btn outline" href="<?= h($base) ?>/galerie.php">← Retour galerie</a></p>

  <h1 style="margin-top:12px;"><?= h((string)$item['title']) ?></h1>

  <div style="display:flex; gap:8px; flex-wrap:wrap; align-items:center; margin-top:8px;">
    <?php if (!empty($item['category'])): ?>
      <span class="badge"><?= h((string)$item['category']) ?></span>
    <?php endif; ?>
    <span class="badge"><?= h((string)$item['created_at']) ?></span>
  </div>

  <img
    src="/couture_site/<?= h((string)$item['image_path']) ?>"
    alt="<?= h((string)$item['title']) ?>"
    style="width:100%; height:auto; border-radius:16px; border:1px solid #eaeaea; margin-top:12px;"
  >

  <?php if (!empty($item['description'])): ?>
    <div class="card" style="margin-top:12px;">
      <h2>Description</h2>
      <p><?= nl2br(h((string)$item['description'])) ?></p>
    </div>
  <?php endif; ?>
</div>

<?php require __DIR__ . '/partials/footer.php'; ?>
