<?php
// public/galerie.php
declare(strict_types=1);

require __DIR__ . '/../config/db.php';
require __DIR__ . '/partials/header.php';

$pdo = db();

$q = trim((string)($_GET['q'] ?? ''));
$category = trim((string)($_GET['category'] ?? ''));
$sort = trim((string)($_GET['sort'] ?? 'recent')); // recent|old

// Liste catégories (distinct)
$categories = [];
try {
    $stmt = $pdo->query("SELECT DISTINCT category FROM gallery_items WHERE is_published = 1 AND category IS NOT NULL AND category <> '' ORDER BY category ASC");
    $categories = array_values(array_filter(array_map(fn($r) => (string)$r['category'], $stmt->fetchAll())));
} catch (Throwable $e) {
    $categories = [];
}

// Query items avec filtres
$where = ["is_published = 1"];
$params = [];

if ($q !== '') {
    $where[] = "(title LIKE :q OR description LIKE :q)";
    $params[':q'] = '%' . $q . '%';
}
if ($category !== '') {
    $where[] = "category = :cat";
    $params[':cat'] = $category;
}

$orderBy = ($sort === 'old') ? "created_at ASC" : "created_at DESC";

$sql = "
  SELECT id, title, description, category, image_path, created_at
  FROM gallery_items
  WHERE " . implode(' AND ', $where) . "
  ORDER BY $orderBy
  LIMIT 60
";

$items = [];
try {
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $items = $stmt->fetchAll();
} catch (Throwable $e) {
    $items = [];
}

// URLs utiles
$base = rtrim($baseUrl, '/');
?>
<div class="card">
  <h1>Galerie</h1>
  <p>Filtre par catégorie, recherche, et clique pour voir les détails.</p>

  <form method="get" action="" class="gallery-toolbar" style="margin-top:12px;">
    <div class="field">
      <label>Recherche</label>
      <input name="q" value="<?= h($q) ?>" placeholder="ex: robe, retouche...">
    </div>

    <div class="field">
      <label>Catégorie</label>
      <select name="category">
        <option value="">— Toutes —</option>
        <?php foreach ($categories as $cat): ?>
          <option value="<?= h($cat) ?>" <?= ($cat === $category) ? 'selected' : '' ?>>
            <?= h($cat) ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>

    <div class="field">
      <label>Tri</label>
      <select name="sort">
        <option value="recent" <?= ($sort === 'recent') ? 'selected' : '' ?>>Plus récent</option>
        <option value="old" <?= ($sort === 'old') ? 'selected' : '' ?>>Plus ancien</option>
      </select>
    </div>

    <div class="field" style="display:flex; gap:10px; align-items:end;">
      <button class="btn" type="submit">Appliquer</button>
      <a class="btn outline" href="<?= h($base) ?>/galerie.php">Réinitialiser</a>
    </div>
  </form>
</div>

<div class="grid" style="margin-top:12px;">
  <?php if (!$items): ?>
    <div class="card col-12">
      <p>Aucun résultat.</p>
    </div>
  <?php else: ?>
    <?php foreach ($items as $it): ?>
      <div class="card col-6">
        <a href="<?= h($base) ?>/galerie_detail.php?id=<?= (int)$it['id'] ?>" style="text-decoration:none; color:inherit;">
          <img
            src="/couture_site/<?= h((string)$it['image_path']) ?>"
            alt="<?= h((string)$it['title']) ?>"
            class="js-lightbox"
            data-full="/couture_site/<?= h((string)$it['image_path']) ?>"
            style="width:100%; height:auto; border-radius:12px; border:1px solid #eaeaea; margin-bottom:10px;"
          >
          <h2 style="margin-bottom:6px;"><?= h((string)$it['title']) ?></h2>
        </a>

        <div style="display:flex; gap:8px; flex-wrap:wrap; align-items:center;">
          <?php if (!empty($it['category'])): ?>
            <span class="badge"><?= h((string)$it['category']) ?></span>
          <?php endif; ?>
          <span class="badge"><?= h((string)$it['created_at']) ?></span>
        </div>

        <?php if (!empty($it['description'])): ?>
          <p style="margin-top:10px;"><?= nl2br(h((string)$it['description'])) ?></p>
        <?php endif; ?>

        <p style="margin-top:10px;">
          <a class="btn outline" href="<?= h($base) ?>/galerie_detail.php?id=<?= (int)$it['id'] ?>">Voir détails</a>
        </p>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>
</div>

<!-- Lightbox overlay -->
<div class="lightbox-overlay" id="lightbox">
  <button class="lightbox-close" type="button" id="lightboxClose">Fermer</button>
  <div class="lightbox-content">
    <img src="" alt="" id="lightboxImg">
  </div>
</div>

<script>
(function () {
  const overlay = document.getElementById('lightbox');
  const img = document.getElementById('lightboxImg');
  const btnClose = document.getElementById('lightboxClose');

  function close() {
    overlay.classList.remove('open');
    img.src = '';
  }

  document.addEventListener('click', (e) => {
    const target = e.target;
    if (!(target instanceof HTMLElement)) return;

    // clic sur image => lightbox (sans empêcher l'accès aux détails si on clique ailleurs)
    if (target.classList.contains('js-lightbox')) {
      e.preventDefault();
      const full = target.getAttribute('data-full') || target.getAttribute('src') || '';
      if (!full) return;
      img.src = full;
      overlay.classList.add('open');
      return;
    }

    // clic sur overlay
    if (target.id === 'lightbox') close();
    if (target.id === 'lightboxClose') close();
  });

  document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape') close();
  });
})();
</script>

<?php require __DIR__ . '/partials/footer.php'; ?>
