<?php
declare(strict_types=1);

require __DIR__ . '/../config/db.php';
require __DIR__ . '/partials/header.php';

$ok = '';
$err = '';

$name = trim($_POST['name'] ?? '');
$email = trim($_POST['email'] ?? '');
$phone = trim($_POST['phone'] ?? '');
$message = trim($_POST['message'] ?? '');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($name === '' || $email === '' || $message === '') {
        $err = "Nom, email et message sont obligatoires.";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $err = "Email invalide.";
    } else {
        try {
            $pdo = db();
            $stmt = $pdo->prepare("INSERT INTO contact_messages (name, email, phone, message) VALUES (:n, :e, :p, :m)");
            $stmt->execute([
                ':n' => $name,
                ':e' => $email,
                ':p' => ($phone !== '' ? $phone : null),
                ':m' => $message,
            ]);
            $ok = "Message envoyé. Merci !";
            $name = $email = $phone = $message = '';
        } catch (Throwable $e) {
            $err = "Erreur serveur lors de l’envoi.";
        }
    }
}
?>
<div class="card">
  <h1>Contact</h1>

  <?php if ($ok): ?><div class="notice ok"><?= h($ok) ?></div><?php endif; ?>
  <?php if ($err): ?><div class="notice err"><?= h($err) ?></div><?php endif; ?>

  <form method="post" action="">
    <div class="form-row">
      <div>
        <label>Nom *</label>
        <input name="name" value="<?= h($name) ?>" required>
      </div>
      <div>
        <label>Email *</label>
        <input name="email" value="<?= h($email) ?>" required>
      </div>
    </div>

    <label>Téléphone</label>
    <input name="phone" value="<?= h($phone) ?>">

    <label>Message *</label>
    <textarea name="message" required><?= h($message) ?></textarea>

    <p style="margin-top:12px;">
      <button class="btn" type="submit">Envoyer</button>
    </p>
  </form>
</div>
<?php require __DIR__ . '/partials/footer.php'; ?>
