<?php
// auth/login.php
declare(strict_types=1);

require_once __DIR__ . '/auth.php';

start_session_once();

$err = '';
$username = trim($_POST['username'] ?? '');

if (is_logged_in()) {
    header('Location: /couture_site/admin/dashboard.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $password = (string)($_POST['password'] ?? '');

    if ($username === '' || $password === '') {
        $err = "Nom d'utilisateur et mot de passe requis.";
    } else {
        try {
            $ok = login_admin($username, $password);
            if ($ok) {
                header('Location: /couture_site/admin/dashboard.php');
                exit;
            }
            $err = "Identifiants invalides.";
        } catch (Throwable $e) {
            $err = "Erreur serveur.";
        }
    }
}
?>
<!doctype html>
<html lang="fr">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Connexion Admin</title>
  <link rel="stylesheet" href="/couture_site/public/assets/css/style.css">
</head>
<body>
<main class="container">
  <div class="card" style="max-width:520px; margin: 40px auto;">
    <h1>Connexion Admin</h1>

    <?php if ($err): ?>
      <div class="notice err"><?= h($err) ?></div>
    <?php endif; ?>

    <form method="post" action="">
      <label>Nom d’utilisateur</label>
      <input name="username" value="<?= h($username) ?>" autocomplete="username" required>

      <label>Mot de passe</label>
      <input type="password" name="password" autocomplete="current-password" required>

      <p style="margin-top:12px; display:flex; gap:10px; align-items:center;">
        <button class="btn" type="submit">Se connecter</button>
        <a class="btn outline" href="/couture_site/public/index.php">Retour au site</a>
      </p>
    </form>
  </div>
</main>
</body>
</html>
