<?php
// admin/gallery_list.php
declare(strict_types=1);

require_once __DIR__ . '/../auth/auth.php';
require_login();

require_once __DIR__ . '/../config/db.php';
$pdo = db();

// Toggle publication
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['toggle_publish_id'])) {
    $id = (int)($_POST['toggle_publish_id'] ?? 0);
    if ($id > 0) {
        $stmt = $pdo->prepare("UPDATE gallery_items SET is_published = CASE WHEN is_published=1 THEN 0 ELSE 1 END, updated_at = NOW() WHERE id = :id");
        $stmt->execute([':id' => $id]);
    }
    header('Location: /couture_site/admin/gallery_list.php');
    exit;
}

$rows = [];
try {
    $stmt = $pdo->query("
        SELECT id, title, category, image_path, is_published, created_at
        FROM gallery_items
        ORDER BY created_at DESC
        LIMIT 300
    ");
    $rows = $stmt->fetchAll();
} catch (Throwable $e) {
    $rows = [];
}
?>
<!doctype html>
<html lang="fr">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Admin — Galerie</title>
  <link rel="stylesheet" href="/couture_site/public/assets/css/style.css">
</head>
<body>
<header class="site-header">
  <div class="container header-row">
    <div class="brand"><a href="/couture_site/admin/dashboard.php">Admin</a></div>
    <nav class="nav">
      <a href="/couture_site/admin/dashboard.php">Dashboard</a>
      <a href="/couture_site/admin/contacts_list.php">Contacts</a>
      <a href="/couture_site/admin/appointments_list.php">Rendez-vous</a>
      <a class="active" href="/couture_site/admin/gallery_list.php">Galerie</a>
      <a href="/couture_site/public/index.php">Site</a>
      <a href="/couture_site/auth/logout.php">Déconnexion</a>
    </nav>
  </div>
</header>

<main class="container">
  <div class="card">
    <div style="display:flex; justify-content:space-between; gap:10px; flex-wrap:wrap; align-items:center;">
      <div>
        <h1>Galerie (Admin)</h1>
        <p>Gère tes réalisations : ajout, modification, publication.</p>
      </div>
      <div>
        <a class="btn" href="/couture_site/admin/gallery_form.php">+ Ajouter</a>
      </div>
    </div>
  </div>

  <div class="grid" style="margin-top:12px;">
    <?php if (!$rows): ?>
      <div class="card col-12"><p>Aucun élément.</p></div>
    <?php else: ?>
      <?php foreach ($rows as $r): ?>
        <div class="card col-12">
          <div style="display:flex; justify-content:space-between; gap:12px; flex-wrap:wrap;">
            <div style="min-width:240px;">
              <h2 style="margin-bottom:6px;"><?= h((string)$r['title']) ?></h2>
              <p style="margin-bottom:6px;">
                <strong>Catégorie :</strong> <?= h((string)($r['category'] ?? '')) ?>
              </p>
              <p style="margin-bottom:6px;">
                <strong>Statut :</strong>
                <?= ((int)$r['is_published'] === 1) ? 'Publié' : 'Non publié' ?>
              </p>
              <p style="margin-bottom:0;">
                <small><?= h((string)$r['created_at']) ?></small>
              </p>
            </div>

            <div style="flex:1; min-width:260px;">
              <?php if (!empty($r['image_path'])): ?>
                <img
                  src="/couture_site/<?= h((string)$r['image_path']) ?>"
                  alt=""
                  style="max-width:260px; width:100%; height:auto; border-radius:12px; border:1px solid #eaeaea;"
                >
              <?php endif; ?>
            </div>

            <div style="display:flex; gap:10px; align-items:flex-start; flex-wrap:wrap;">
              <a class="btn outline" href="/couture_site/admin/gallery_form.php?id=<?= (int)$r['id'] ?>">Modifier</a>

              <form method="post" action="" style="margin:0;">
                <input type="hidden" name="toggle_publish_id" value="<?= (int)$r['id'] ?>">
                <button class="btn outline" type="submit">
                  <?= ((int)$r['is_published'] === 1) ? 'Dépublier' : 'Publier' ?>
                </button>
              </form>

              <a class="btn outline" href="/couture_site/admin/gallery_delete.php?id=<?= (int)$r['id'] ?>"
                 onclick="return confirm('Supprimer cet élément ?');">Supprimer</a>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    <?php endif; ?>
  </div>
</main>
</body>
</html>
