<?php
// admin/gallery_delete.php
declare(strict_types=1);

require_once __DIR__ . '/../auth/auth.php';
require_login();

require_once __DIR__ . '/../config/db.php';
$pdo = db();

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    header('Location: /couture_site/admin/gallery_list.php');
    exit;
}

// Récupère l'image
$stmt = $pdo->prepare("SELECT image_path FROM gallery_items WHERE id = :id");
$stmt->execute([':id' => $id]);
$row = $stmt->fetch();

if ($row) {
    $img = (string)($row['image_path'] ?? '');
    // Supprime DB
    $del = $pdo->prepare("DELETE FROM gallery_items WHERE id = :id");
    $del->execute([':id' => $id]);

    // Supprime fichier (si existe)
    if ($img !== '') {
        $abs = __DIR__ . '/../' . $img;
        if (is_file($abs)) {
            @unlink($abs);
        }
    }
}

header('Location: /couture_site/admin/gallery_list.php');
exit;
