<?php
// admin/dashboard.php
declare(strict_types=1);

require_once __DIR__ . '/../auth/auth.php';
require_login();

require_once __DIR__ . '/../config/db.php';

$pdo = db();

function h(string $v): string {
    return htmlspecialchars($v, ENT_QUOTES, 'UTF-8');
}

$counts = [
    'contacts_total' => 0,
    'contacts_unread' => 0,
    'appointments_total' => 0,
    'appointments_unread' => 0,
    'appointments_new' => 0,
    'gallery_total' => 0,
    'gallery_published' => 0,
];

try {
    $counts['contacts_total'] = (int)$pdo->query("SELECT COUNT(*) FROM contact_messages")->fetchColumn();
    $counts['contacts_unread'] = (int)$pdo->query("SELECT COUNT(*) FROM contact_messages WHERE is_read = 0")->fetchColumn();

    $counts['appointments_total'] = (int)$pdo->query("SELECT COUNT(*) FROM appointment_requests")->fetchColumn();
    $counts['appointments_unread'] = (int)$pdo->query("SELECT COUNT(*) FROM appointment_requests WHERE is_read = 0")->fetchColumn();
    $counts['appointments_new'] = (int)$pdo->query("SELECT COUNT(*) FROM appointment_requests WHERE status = 'nouveau'")->fetchColumn();

    $counts['gallery_total'] = (int)$pdo->query("SELECT COUNT(*) FROM gallery_items")->fetchColumn();
    $counts['gallery_published'] = (int)$pdo->query("SELECT COUNT(*) FROM gallery_items WHERE is_published = 1")->fetchColumn();
} catch (Throwable $e) {
    // keep zeros
}

$user = admin_username();
?>
<!doctype html>
<html lang="fr">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Admin — Dashboard</title>
  <link rel="stylesheet" href="/couture_site/public/assets/css/style.css">
</head>
<body>
<header class="site-header">
  <div class="container header-row">
    <div class="brand">
      <a href="/couture_site/admin/dashboard.php">Admin</a>
    </div>
    <nav class="nav">
      <a class="active" href="/couture_site/admin/dashboard.php">Dashboard</a>
      <a href="/couture_site/admin/contacts_list.php">Contacts</a>
      <a href="/couture_site/admin/appointments_list.php">Rendez-vous</a>
      <a href="/couture_site/admin/gallery_list.php">Galerie</a>
      <a href="/couture_site/public/index.php">Site</a>
      <a href="/couture_site/auth/logout.php">Déconnexion</a>
    </nav>
  </div>
</header>

<main class="container">
  <div class="card">
    <h1>Dashboard</h1>
    <p>Connecté : <strong><?= h($user) ?></strong></p>
  </div>

  <div class="grid" style="margin-top:12px;">
    <div class="card col-6">
      <h2>Messages Contact</h2>
      <p>Total : <strong><?= (int)$counts['contacts_total'] ?></strong></p>
      <p>Non lus : <strong><?= (int)$counts['contacts_unread'] ?></strong></p>
      <a class="btn outline" href="/couture_site/admin/contacts_list.php">Voir</a>
    </div>

    <div class="card col-6">
      <h2>Demandes de rendez-vous</h2>
      <p>Total : <strong><?= (int)$counts['appointments_total'] ?></strong></p>
      <p>Non lus : <strong><?= (int)$counts['appointments_unread'] ?></strong></p>
      <p>Nouveaux : <strong><?= (int)$counts['appointments_new'] ?></strong></p>
      <a class="btn outline" href="/couture_site/admin/appointments_list.php">Voir</a>
    </div>

    <div class="card col-12">
      <h2>Galerie</h2>
      <p>Total : <strong><?= (int)$counts['gallery_total'] ?></strong></p>
      <p>Publiés : <strong><?= (int)$counts['gallery_published'] ?></strong></p>
      <a class="btn outline" href="/couture_site/admin/gallery_list.php">Gérer la galerie</a>
    </div>
  </div>
</main>
</body>
</html>
