<?php
// auth/create_admin_once.php
declare(strict_types=1);

require_once __DIR__ . '/../config/db.php';

$pdo = db();

// IMPORTANT: change ces valeurs puis lance la page 1 seule fois
$username = 'admin';
$password = 'admin12345'; // change ça

// Sécurité simple: empêche création si un admin existe déjà
$exists = (int)$pdo->query("SELECT COUNT(*) FROM admins")->fetchColumn();
if ($exists > 0) {
    echo "Un admin existe déjà. Supprime ce fichier.";
    exit;
}

$hash = password_hash($password, PASSWORD_DEFAULT);

$stmt = $pdo->prepare("INSERT INTO admins (username, password_hash) VALUES (:u, :h)");
$stmt->execute([':u' => $username, ':h' => $hash]);

echo "Admin créé: {$username}. Supprime maintenant auth/create_admin_once.php";
