<?php
// admin/contacts_list.php
declare(strict_types=1);

require_once __DIR__ . '/../auth/auth.php';
require_login();

require_once __DIR__ . '/../config/db.php';
$pdo = db();

// Marquer un message comme lu
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['mark_read_id'])) {
    $id = (int)($_POST['mark_read_id'] ?? 0);
    if ($id > 0) {
        $stmt = $pdo->prepare("UPDATE contact_messages SET is_read = 1 WHERE id = :id");
        $stmt->execute([':id' => $id]);
    }
    header('Location: /couture_site/admin/contacts_list.php');
    exit;
}

$rows = [];
try {
    $stmt = $pdo->query("
        SELECT id, name, email, phone, message, created_at, is_read
        FROM contact_messages
        ORDER BY created_at DESC
        LIMIT 200
    ");
    $rows = $stmt->fetchAll();
} catch (Throwable $e) {
    $rows = [];
}
?>
<!doctype html>
<html lang="fr">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Admin — Contacts</title>
  <link rel="stylesheet" href="/couture_site/public/assets/css/style.css">
</head>
<body>
<header class="site-header">
  <div class="container header-row">
    <div class="brand"><a href="/couture_site/admin/dashboard.php">Admin</a></div>
    <nav class="nav">
      <a href="/couture_site/admin/dashboard.php">Dashboard</a>
      <a class="active" href="/couture_site/admin/contacts_list.php">Contacts</a>
      <a href="/couture_site/admin/appointments_list.php">Rendez-vous</a>
      <a href="/couture_site/public/index.php">Site</a>
      <a href="/couture_site/auth/logout.php">Déconnexion</a>
    </nav>
  </div>
</header>

<main class="container">
  <div class="card">
    <h1>Messages Contact</h1>
    <p>Liste des 200 derniers messages.</p>
  </div>

  <div class="grid" style="margin-top:12px;">
    <?php if (!$rows): ?>
      <div class="card col-12"><p>Aucun message.</p></div>
    <?php else: ?>
      <?php foreach ($rows as $r): ?>
        <div class="card col-12">
          <div style="display:flex; justify-content:space-between; gap:10px; flex-wrap:wrap;">
            <div>
              <strong><?= h($r['name']) ?></strong>
              <?php if (!(int)$r['is_read']): ?>
                <span style="margin-left:8px;">(NON LU)</span>
              <?php endif; ?>
              <div><?= h($r['email']) ?><?= $r['phone'] ? ' — ' . h($r['phone']) : '' ?></div>
              <div><small><?= h((string)$r['created_at']) ?></small></div>
            </div>

            <div>
              <?php if (!(int)$r['is_read']): ?>
                <form method="post" action="" style="margin:0;">
                  <input type="hidden" name="mark_read_id" value="<?= (int)$r['id'] ?>">
                  <button class="btn outline" type="submit">Marquer lu</button>
                </form>
              <?php endif; ?>
            </div>
          </div>

          <div style="margin-top:10px;">
            <?= nl2br(h((string)$r['message'])) ?>
          </div>
        </div>
      <?php endforeach; ?>
    <?php endif; ?>
  </div>
</main>
</body>
</html>
