<?php
// admin/appointments_list.php
declare(strict_types=1);

require_once __DIR__ . '/../auth/auth.php';
require_login();

require_once __DIR__ . '/../config/db.php';
$pdo = db();

// Actions : marquer lu, changer statut
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['mark_read_id'])) {
        $id = (int)($_POST['mark_read_id'] ?? 0);
        if ($id > 0) {
            $stmt = $pdo->prepare("UPDATE appointment_requests SET is_read = 1 WHERE id = :id");
            $stmt->execute([':id' => $id]);
        }
        header('Location: /couture_site/admin/appointments_list.php');
        exit;
    }

    if (isset($_POST['status_id'], $_POST['status'])) {
        $id = (int)($_POST['status_id'] ?? 0);
        $status = (string)($_POST['status'] ?? '');

        $allowed = ['nouveau','confirmé','refusé','complété'];
        if ($id > 0 && in_array($status, $allowed, true)) {
            $stmt = $pdo->prepare("UPDATE appointment_requests SET status = :s WHERE id = :id");
            $stmt->execute([':s' => $status, ':id' => $id]);
        }
        header('Location: /couture_site/admin/appointments_list.php');
        exit;
    }
}

$rows = [];
try {
    $stmt = $pdo->query("
        SELECT id, name, email, phone, service, preferred_date, preferred_time, details,
               status, created_at, is_read
        FROM appointment_requests
        ORDER BY created_at DESC
        LIMIT 200
    ");
    $rows = $stmt->fetchAll();
} catch (Throwable $e) {
    $rows = [];
}

$allowedStatus = ['nouveau','confirmé','refusé','complété'];
?>
<!doctype html>
<html lang="fr">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Admin — Rendez-vous</title>
  <link rel="stylesheet" href="/couture_site/public/assets/css/style.css">
</head>
<body>
<header class="site-header">
  <div class="container header-row">
    <div class="brand"><a href="/couture_site/admin/dashboard.php">Admin</a></div>
    <nav class="nav">
      <a href="/couture_site/admin/dashboard.php">Dashboard</a>
      <a href="/couture_site/admin/contacts_list.php">Contacts</a>
      <a class="active" href="/couture_site/admin/appointments_list.php">Rendez-vous</a>
      <a href="/couture_site/public/index.php">Site</a>
      <a href="/couture_site/auth/logout.php">Déconnexion</a>
    </nav>
  </div>
</header>

<main class="container">
  <div class="card">
    <h1>Demandes de rendez-vous</h1>
    <p>Liste des 200 dernières demandes.</p>
  </div>

  <div class="grid" style="margin-top:12px;">
    <?php if (!$rows): ?>
      <div class="card col-12"><p>Aucune demande.</p></div>
    <?php else: ?>
      <?php foreach ($rows as $r): ?>
        <div class="card col-12">
          <div style="display:flex; justify-content:space-between; gap:10px; flex-wrap:wrap;">
            <div>
              <strong><?= h($r['name']) ?></strong>
              <?php if (!(int)$r['is_read']): ?>
                <span style="margin-left:8px;">(NON LU)</span>
              <?php endif; ?>
              <div><?= h($r['email']) ?><?= $r['phone'] ? ' — ' . h($r['phone']) : '' ?></div>
              <div><small><?= h((string)$r['created_at']) ?></small></div>
            </div>

            <div style="display:flex; gap:10px; align-items:center; flex-wrap:wrap;">
              <div>
                <strong>Statut :</strong> <?= h((string)$r['status']) ?>
              </div>

              <form method="post" action="" style="margin:0; display:flex; gap:8px; align-items:center;">
                <input type="hidden" name="status_id" value="<?= (int)$r['id'] ?>">
                <select name="status">
                  <?php foreach ($allowedStatus as $st): ?>
                    <option value="<?= h($st) ?>" <?= ($r['status'] === $st) ? 'selected' : '' ?>>
                      <?= h($st) ?>
                    </option>
                  <?php endforeach; ?>
                </select>
                <button class="btn outline" type="submit">Changer</button>
              </form>

              <?php if (!(int)$r['is_read']): ?>
                <form method="post" action="" style="margin:0;">
                  <input type="hidden" name="mark_read_id" value="<?= (int)$r['id'] ?>">
                  <button class="btn outline" type="submit">Marquer lu</button>
                </form>
              <?php endif; ?>
            </div>
          </div>

          <div style="margin-top:10px;">
            <p><strong>Service :</strong> <?= h((string)($r['service'] ?? '')) ?></p>
            <p><strong>Date/heure souhaitée :</strong>
              <?= h((string)($r['preferred_date'] ?? '')) ?>
              <?= $r['preferred_time'] ? ' — ' . h((string)$r['preferred_time']) : '' ?>
            </p>
            <?php if (!empty($r['details'])): ?>
              <p><strong>Détails :</strong><br><?= nl2br(h((string)$r['details'])) ?></p>
            <?php endif; ?>
          </div>
        </div>
      <?php endforeach; ?>
    <?php endif; ?>
  </div>
</main>
</body>
</html>
